Article

# Artificial Intelligence and Business Strategy towards Digital Transformation: A Research Agenda

Fotis Kitsios $\textcircled{1}$ and Maria Kamariotou $\ast ( \textcircled { 1 }$

Citation: Kitsios, F.; Kamariotou, M. Artificial Intelligence and Business Strategy towards Digital Transformation: A Research Agenda. Sustainability 2021, 13, 2025. https://doi.org/10.3390/su13042025

Academic Editor: Cecilia Rossignoli

Received: 29 December 2020   
Accepted: 9 February 2021   
Published: 13 February 2021

Publisher’s Note: MDPI stays neutral with regard to jurisdictional claims in published maps and institutional affiliations.

Department of Applied Informatics, University of Macedonia, GR54636 Thessaloniki, Greece; kitsios@uom.gr \* Correspondence: mkamariotou@uom.edu.gr

Abstract: In the past decade, current literature and businesses have drawn attention to Artificial Intelligence (AI) tools and in particular to the advances in machine learning techniques. Nevertheless, while the AI technology offers great potential to solve difficulties, challenges remain implicated in practical implementation and lack of expertise in the strategic usage of AI to create business value. This paper aims to implement a systematic literature review analyzing convergence of the AI and corporate strategy and develop a theoretical model incorporating issues based on the existing research in this field. Eighty-one peer-reviewed articles were discussed on the basis of research methodology from Webster and Watson (2002). In addition to gaps in future research, a theoretical model is developed, discussing the four sources of value creation: AI and Machine Learning in organizations; alignment of AI tools and Information Technology (IT) with organizational strategy; AI, knowledge management and decision-making process; and AI, service innovation and value. These outcomes lead to both theoretical and managerial viewpoints, with extensive possibilities to generate new methods and types of management practices.

Keywords: artificial intelligence; business strategy; digital transformation; information technology; Industry 4.0; sustainable competitive advantage

# 1. Introduction

In the digital age, businesses need reduced waiting periods and thus more awareness in the market environment that could alter faster than previous decades. Through this view, several organizations have been adopting emerging technologies designed to obtain high performance and a competitive advantage [1]. Amongst these advancements, Artificial Intelligence (AI) has held a pivotal position [2] and has drawn the attention of both researchers and the industrial sector. AI is referred to as the ability of a machine to learn from experience, adjust to new inputs and implement human-like tasks [3]. As per [3], AI could now be the innovation entity with the most significant potential for disruption. Likewise, in the case of [4], AI is the fundamental multi-purpose technology in the domain, especially in relation to machine learning tools.

In the past decade, the vast amount of data collected in a variety of formats has been faster than ever before. It called for the advent of new technologies, culminating in hastening of technological developments that also incorporates the computational in the processing capabilities as well as the advancement of new AI techniques [1,5]. With these advances, firms are allowed to process vast quantities of data with AI by using the outcomes to broaden their purpose of new markets, products and services [6,7].

Taking into consideration the competitive environment of businesses and with vast amounts of data, scarce assets, hence the requirements for velocity in decision-making, several companies have been inspired to implement AI tools, primarily due to their expected implications exhibited by leading digital enterprises [8–12]. Recognizing that the process of transformation involves a review of the corporate strategy, various leading companies are reconsidering the strategic plans for integration of AI tools [13]. Although, researchers argued that further investigation is required to evaluate the magnitude of AI in the organizational planning and implementation of business strategy [14], since, as of yet, there are limited theoretical and empirical findings about the creation of value propositions through AI technologies [3,8,14–18]. The objective of companies is to establish sustainable performance and sustainable competitive advantage by integrating technology into the decision-making process with corporate strategy. Businesses are supposed to be more flexible and responsive to strategic decision-making in the current dynamic environment. Companies that will maintain their competitive advantage are able to exceed the remainders in the long run [14,19].

Few researchers study the literature about AI from a managerial viewpoint, addressing the management of information [6,11,20–22]; decision-making [3,23,24]; knowledge management [25]; and skills [5,26–29]. This paper, therefore, to the best of our understanding, varies from those previously conducted by synthesizing to a systematic review of literature by examining the state of the correlation between AI and organizational strategy, a topic not included in the aforementioned articles.

The utilization of Information Technology (IT) by businesses as a strategic instrument is not a current phenomenon [30–33], yet the correlation of the use of AI technologies with organizational strategy is considerably more complicated in respect to other technologies, whereas AI applications can accomplish functions requiring cognition [34,35]. In this context, it is more difficult than anticipated to obtain value from AI investments owing to the paradox that the same person can have favourable or unfavourable perceptions concerning AI based on the particular situation [36].

This article aims to implement a systematic literature review examining the correlation of AI and corporate strategy and to provide a framework for interrelated issues in line with the existing research in this field. Eighty-one peer-reviewed articles were evaluated on the basis of research methodology from Webster and Watson (2002) [37]. Given the changes that have taken place in the field of AI in previous years, the attention of leading companies of AI technologies and the obstacles associated in acquiring business value through the usage of this form of technology, it is important to establish and to contextualize the current research about the connection between AI and organizational strategy. As a result, the following concerns appear: (i) What are the motivations for adoption of AI strategically? (ii) What implications and advantages have companies obtained from the usage of AI in the context of organizational strategy?

The principal motivation is to set up a “state-of-the-art” update by introducing a synthesis of scholarly research on AI and business strategy. This paper provides a solid theoretical background of the existing literature by analyzing papers using Webster and Watson’s (2002) [37] literature review methodology. This methodology is concept-driven and it helps to analyze the different concepts and contexts studied in this paper and to more readily comprehend ongoing turns of developments. Authors expect that, in reading this paper, researchers will have the option to increase a reasonable understanding of what past researchers have done in AI and corporate strategy and the limitations of momentum research.

This paper’s structure is arranged as follows: Section 2 describes the methodology adopted in order to implement the literature review. Next, the outcomes of the analysis of the articles are presented in Section 3. The last section addresses conclusions and avenues for further research.

# 2. Materials and Methods

Papers have been discovered utilizing a literature review methodology including three stages, which was recommended by Webster and Watson (2002) [37], and has been recently utilized in strategic management and Information Systems research [38–43]. Initially, the current literature reviews were searched to choose the databases and keywords of the basic search. Afterwards, the backward search was executed to look at the references of the chosen articles and, in the end, the forward search to inspect the citations of the chosen articles in order to increase their sum. After the choice of the articles, these were classified by their content.

# 2.1. Previous Literature Reviews

The current literature review articles are introduced in order to present the latest literature on current knowledge of the area of AI and organizational strategy and to analyze the existing knowledge of this territory just as to examine the distinguished research questions dependent on the outcomes of past papers. Likewise, current literature review papers provide an outline of the methodologies adopted by authors and feature their significance and research gaps in their usage. Table 1 displays an outline of the current literature review papers in this area.

Table 1. Previous literature reviews.   

<html><body><table><tr><td>Authors</td><td>Year</td><td>Methodology</td><td>Results</td></tr><tr><td>Borges et al. [44]</td><td>2020</td><td>Searching for peer-reviewed and conference papers in 2 databases</td><td>Results were analyzed based on 4</td></tr><tr><td>Caner and Bhatti [45]</td><td>2020</td><td>Searching for peer-reviewed papers management field and social sciencesPapers published between 2015 and 2019</td><td>deveopeptua frer wdekitwe A 1 abouiablitrsanindinsA economics and AI, business functions and AI, workforce,industries and AI, and regulations and ethics of AI.</td></tr><tr><td>Trunk et al. [46]</td><td>2020</td><td>Searching for peer-reviewed papers in 4 databases using keywords regarding Artificial Intelligence, Machine Learning and Decision-MakingPapers published between 2016 and 2019</td><td>A conceptual framework was developed in order to define how humans can use AI for decision-making under uncertainty.</td></tr></table></body></html>

Borges et al. (2020) [44] implemented a literature review to analyze the correlation between AI and strategy to make business value. In this view, this article planned to bridge this gap by: conducting a significant literature review identified with the combination of AI with business strategy; combining the current approaches with models, featuring the expected advantages, difficulties and opportunities; introducing a conversation for further research avenues. They selected articles in peer-reviewed journals and conference proceedings and created a framework in order to introduce research gaps.

Caner and Bhatti (2020) [45] conducted a systematic literature review in peer-reviewed scientific journal papers to present a theoretical model on examining AI organizational strategy. They focused on papers published between 2015 and 2019. They inferred that the significant components of AI in organizations are capabilities and restrictions of AI, financial matter and AI, organizational functions and AI, workforce, industries and AI, and laws and ethics of AI on identifying AI corporate strategy.

Trunk et al. (2020) [46] implemented a literature review to analyze the connection between AI and decision-making under dynamic environments in businesses. Authors searched for peer-reviewed papers and conducted a content analysis as a means to offer a summary of the possibilities of existing studies defining for correlating AI and business decision-making in dynamic environments. The outcomes are presented in a theoretical framework that first describes how humans can adopt AI for decision-making in dynamic environments and then presents the difficulties, pre-conditions, and consequences that should be taken into consideration.

# 2.2. Article Selection Process

The search was carried out in Scopus, ScienceDirect, Web of Science and ABI/INFORM databases using combinations of the following keywords: ‘artificial intelligence’, ‘machine learning’, ‘deep learning’, ‘representation learning’, ‘strategic plan’, ‘emergent strategy’, ‘strategy execution’, ‘competitive strategy’, ‘competitive advantage’, ‘digital strategy’, ‘business strategy’, ‘corporate strategy’, ‘organizational strategy’, ‘information technology strategy’, ‘cognitive strategy’ and ‘strategic use’. Articles were published in peer-reviewed journals, book chapters and conference proceedings. These were chosen without restricting them to a particular period. Books, technical reports and working papers were excluded.

Overall, 1742 articles were assembled utilizing keywords in all databases. As per the limitations of language and the source of publication, papers decreased to 565. Filtering their titles, 126 papers were found relevant to the goal of this study. Subsequently, looking at their abstract, 102 were accepted. Titles and abstracts were checked for the appropriate utilization of search strings. Next, the content of the remaining articles was filtered and only articles esteemed “fit for purpose”, regarding adding to responding to the research questions, were viewed relevant and thusly included. Various articles were excluded on the grounds that their full content was not accessible. These papers have been published in conference proceedings or book chapters. A brief examination was led to verify them. This subsequent overview featured that every one of them ought to be incorporated. Co-authors discussed the degree to which each paper increased the value to the purpose of the paper.

Duplicate papers have been removed and 61 articles have been incorporated. Five of the ‘backward search’ papers were added to these 61 papers. In addition, 15 papers from the ‘forward search’ were added and, as a result, 81 papers in total were examined25 5 of 16 (Figure 1).

![](images/43bbd471b67563b8ff73ec2de2a6d76e95d7899ad52bb7b8088b3abe1a031736.jpg)  
Figure 1. Article selection process.

The search was finished when it came to common papers from all databases and various combinations of keywords. Thus, it was reasoned that the critical amount of relevant literature sources had been gathered [37]. The final sample was examined utilizing an Excel data extraction sheet in which both the illustrative components and the primary results, outcomes and contributions were assembled for each paper.

# 2.3. Classification Framework for Analysis

Eighty-one articles were analyzed dependent on a classification framework. These papers were classified on 4 wide concepts (AI and Machine Learning in organizations; aligning AI tools and IT with business strategy; AI, knowledge management and decision-making process; and AI, service innovation and value) which will provide a better comprehension of AI usage and business strategy and will likewise assist future academics with extending the information in this area. These papers are presented in Table A1 (Appendix A).

# 3. Results

# 3.1. Artificial Intelligence and Machine Learning in Organizations

AI has concepts, insights and techniques in several fields. It is an area that seeks to build software and hardware capable of executing actions that should only be done through the usage of intelligence [47]. The AI area includes every technique that allows devices to work by replicating human actions to produce the best outcome or, in unpredictable scenarios, the best predicted outcome [18,48,49].

In the initial period of AI, the most important difficulty was to execute activities that are easily rectified by a human individual, yet difficult to formally explain with regard to mathematical principles [46]. The challenge in describing this form of activity by specifying the rules showed that AI tools required the capacity to derive regularities from data and to gain their own knowledge [24,25,50]. This skill is referred to as machine learning, which allows computer-based tools to directly identify trends in and out of data; act without being directly programmed [18,48,49]. Consequently, the domain of AI has progressed not only in the context of process rules earlier established by humans to emulate human actions for decision-making (as in traditional AI algorithms), but also to imitate, to mimic human learning.

Advancement of AI with the creation of machine learning algorithms required means of mapping the information gained from the learning process to final conformation. This requirement has led to the creation of interventions classified as representation learning, which have features that have changed an intermediate representation compromising valuable data [18,48,49]. When representations are represented regarding other concepts, just like the situation of complicated notions, it is required to implement deep learning techniques. Deep learning is a type of representational learning that has the ability and flexibility to depict the world across a hierarchy of principles, in which each definition can be described in comparison to unpretentious dimensions. This indicates that deep learning helps computational frameworks to ascertain representations of different degrees of complexity and these models comprise several layers of processing. The key distinction between AI disciplines is the reliance of the human being on creating rules or distinguishing characteristics that describe a challenge. Human reliance on the learning process reduces from the AI layer to inner layers. Traditional machine learning algorithms are a form of AI where a person has to hand-design features that the algorithm can use to present a mapping from features by eliciting patterns and gaining their respective knowledge [18,46].

Representation learning algorithms are a form of machine learning, yet they launch the learning process one stride in front of the traditional machine learning algorithms. Representation learning methods have the ability to gain from features in a human and they can present a mapping from features [48,49]. Deep learning algorithms are a kind of representation learning and they require the individual to identify simply straightforward features. From these simple features, they can identify more dynamic features in extra layers of learning and afterward present a mapping from features [51].

In the organizational point of view, the articles published in the beginning stages of AI started to support the decision-making process during the 1960s [34,52]. AI has been utilized in organizations since the 1980s, being an objective of speculations and endeavors from numerous organizations to plan and to actualize computer vision systems, robots, expert systems, other than software and hardware for those reasons [32]. In addition, around then, AI had just started to be referred to as a strategic instrument to enhance business differentiation at a competitive situation. Until the turn of the millennium, the papers on computer science in the domain of AI had paid attention to the algorithms, to develop new methods or to improve the current ones [35,53]. However, since 2001, academics have proposed that for some AI issues, the difficulty was the amount of data, because of the presence of huge databases [3,20]. Consequently, new AI techniques were created, empowered by the development of hardware. This technological advancement is ascribed to the big data marvel, described by the interchange of technology, methodology and analysis capacity to search and cross-reference enormous data sets to distinguish designs and to acquire knowledge [17,50,54].

The evolution of AI lately and its advancement in numerous fields is because of three main factors: huge volume of data, better algorithms, and considerably improved computational hardware [2,55]. This advancement has pulled in the consideration of enormous technology-oriented businesses to AI technologies. Nowadays, in organizations, AI can be regarded as a tool that has been implemented as a way of replicating human performance with the ability to attract its own assumptions through learning, that can help human intelligence or even substitute humans in activities that need cognition [56]. Generally, AI advancements can achieve performance enhancement as a result of speed, flexibility, customization, scale, innovation, and decision-making [11,26]. Moreover, organizations have many benefits from the utilization of AI to create value across various organizational components: process automation; obtaining knowledge from data for decision-making; involving consumers and employees; developing and launching new products and services [7,12,57–61].

# 3.2. Aligning AI Tools and IT with Business Strategy

In spite of the increase in the digital age, the role and effect of IT in the corporate sense are not current topics. In the late 1970s, scholars began to explore the ability of IT to affect business competition [31,62]. In this context, there are several researchers that have started to use the term “strategic use” to pertain to the ability of IT to formulate future corporate strategies or to help current ones, and to offer meaning to business [13,63]. Nevertheless, there is a historic debate on companies’ inability to produce value from expenditure in IT applications, that many scholars relate to limited levels of alignment between the corporate and IT strategies [30,33,64–66].

According to [67], the alignment between the corporate and IT strategies is a process of prolonged development and change that includes not only organizational strategy and IT strategy, as well business infrastructure and processes, and IT infrastructure and processes. In this case, the strategic usage of IT will allow the business to maintain developments in the competitive situation [12]. Many frameworks, theories and methodologies have been suggested in the research on usage of IT in accordance with the corporate strategy and operation [30,33,64–66]. Gradually, digital technologies have taken a significant role in the organizational strategy [4].

In the digital era, however, Ref. [67] dispute that it is important to reconsider the role of IT strategy. Instead of being viewed as a functional level and, in several situations, guided by a corporate strategy, the IT strategy should be incorporated into the organizational strategy in a systematic way named digital business strategy (or digital strategy), which comprises a corporate strategy developed and applied to leverage digital assets to achieve differential value [8,54]. This context of the merger of IT strategy with organizational strategy is often supported by other scholars, who claim that a complex alignment between IT and organization should take place to obtain a competitive advantage [13,64,65]. Ref. [66] underlined the value of IT-focused applications and the analytic potential given by IT resources to create innovation and increase competitive advantage in the organizational strategy.

Given the advancement of the theoretical and practical contributions of papers exploring the strategic usage of emerging technologies, when it comes to AI, it is substantially more complicated since AI advancements are capable of executing activities that include cognition [67]. This skill helps businesses to dramatically shift the size, mission, and learning paradigms, that show the significant capacity of AI to produce business value. The strategic usage of AI, thus, is identified with harnessing this capacity [8,10,11,68].

Notwithstanding the technological advancement in the most recent decade, researchers and practitioners have taken about that technology is not the principle difficulty embracing AI, yet cultural impediments, process and individuals [3,36,44,69]. To address them, strategy is important that appropriately incorporates knowledge, technology features, individuals, management change and aspirations to change the endeavor and the organization. Naming the new age of AI technologies as cognitive advances, researchers refer to that strategy as cognitive strategy.

# 3.3. AI, Knowledge Management and Decision-Making Process

In spite of the fact that utilization of AI advancements in the decision-making process is a practice that started in the 1960s, one difficulty faced by businesses is identified with decisions associated with planning the IT systems taking into consideration the objectives of organizational strategy. Analytics tools dependent on AI are essential for a significant issue in the decision support topic, as they give information and knowledge according to available data [3,24]. Towards this view, [70] suggested a theoretical model that supports the planning and application of decision support systems in cloud, adding to IT strategy. The utilization of AI as a component of cutting-edge analytics solutions to generate business value was examined by researchers. Refs. [22,24,55] developed theoretical frameworks that incorporate AI advancements, representation learning and machine learning tools to implement classification and prediction tasks with the guarantee of aligning analytics requirements with the organizational strategy. Ref. [36] presented a theoretical framework about the business benefits in terms of competitive advantage acquired from advanced analytics, because of consolidating human knowledge and artificial intelligence.

Marketing was another dimension investigated by researchers, who considered utilizing AI in answers for help in decision-making. Ref. [71] suggested an approach utilizing traditional AI to help executives in making decisions about the product pricing, the investments in promoting and other marketing strategies, additionally the production and distribution planning. [8] examined the significant role of intelligent analytical techniques in the formulation and implementation of marketing strategies, yet the paper outcomes concluded the low degree of adoption of the analytical tools dependent on machine learning to marketing management.

The decision support function of AI-based arrangements was additionally analyzed in social responsibility and sustainability subjects. Ref. [19] presented a hybrid model that adopts traditional AI tools to support the decisions about the priority option of the organization social responsibility program to be executed for comprising it into the corporate strategy. Ref. [21] paid attention to sustainability and utilized AI algorithms to identify priorities and policies for setting up operation strategies from the definition of organizational strategies.

# 3.4. AI, Service Innovation and Value

The utilization of AI aligned with corporate strategy to develop new products or services was covered by several articles. Ref. [58] considered the utilization of AI to empower machine-to-machine communication in new organizational opportunities; however, they did not approve their ideas. Conversely, a few researchers concluded that organizations have obtained the advantages of new product development and offering of new services [57].

For [12], AI technologies can guide innovation directly into industry and this is the most important influence of intelligent technologies. Ref. [60] suggested that AI is rapidly reconstructing the service, executing different functions, becoming a significant source of innovation and generating opportunities for innovative human–machine interaction.

The findings of this study indicate that the strategic implementation of AI tools for consumer and employee engagement has not successfully been implemented as few articles addressed the enhancement of consumer experience. While [7,59] have shown that the usage of AI in relationship with customers produced value for businesses and [68] addressed the utilization of AI to improve the consumer experience, the findings are not generalizable since the usage of AI engagement with humans is complicated [72]. Among the explanations for this ambiguity, humans may not want to note that they are being served or interpreted by a machine. Consequently, this form of reaction may also have a negative effect on the organization.

AI tools may build a competitive advantage by enhancing consumers’ experience and interaction with the applications developed based on digital strategy. Deeper innovation in organizations through new product development will deliver new services based on the cognitive potential of the new age of AI. As a consequence, competitive and cognitive strategies need to be aligned in order to effectively utilize the new age of AI to develop innovative products and solutions. The usage of the next generation of AI technology in accordance with a well-defined digital business strategy, taking into consideration the company requirements, rules and automation, will create a competitive advantage for the business. Thus, it is also required to learn how executives can formulate competitive and cognitive strategies in order to innovate by leveraging the ability of the new age of AI. It is therefore necessary to examine human feelings, attitudes and requirements that fuel the motivations to interact with products and services centered on cognitive technologies.Established research has created a solid ground and now a theoret

Established research has created a solid ground and now a theoretical model can bet on the basis of the literature review. Using an open coding techniq built on the basis of the literature review. Using an open coding technique in order toanalyze the content of the 81 articles aiming at separating the concepts to analyze the content of the 81 articles aiming at separating the concepts to be included in the classification of the articles, it supported readers with a clear indication of the topics of concern (Figure 2).of concern (Figu

![](images/b131605e0a95ae92d90b01e436ded42802dc2ca66327938fac35d119e8d1cc7f.jpg)  
Figure 2. Conceptual FrameFigure 2. Conceptual Framework.

# 4. Conclusions

The purpose of this article was therefore to evaluate the correlation between the use The purpose of this article was therefore to evaluate the correlation bof AI and corporate strategy via a systematic literature review. The literature review was of AI and corporate strategy via a systematic literature review. The literatubased on guidelines of previous systematic studies [37–43,73]. AI technologies have been prominently placed in contemporary organizations. On the other hand, high inspirations are connected to the organization competitive paradigm. For this justification, there is a prominently placed in contemporary organizations. On the other hand, higrowing interest for researchers in the strategic utilization of AI to achieve a competitive edge. While the paper demonstrates the usage of AI in the domain of organizational requirements and strategies, the findings suggest that this context was little discussed by academics and still poses unanswered issues and concerns.

The strategic utilization of AI was tended to by the literature in the accompanying manners: to improve corporate strategy with predictive analytics by visualizing key performance indicators and with image recognition to recognize consumer behavior, to choose the best option for IT infrastructure design plans based on future organizational conditions and its effects on the requirement to alter IT transformations, to successfully develop decision support systems to support strategically the decision-making process, to grow new organizational openings and capacity for innovation, to take out certain challenges with respect to product attributes and machine functionalities, to improve product quality and increasing business performance.

These outcomes are applicable to both theoretical and practical viewpoints, with broad possibilities for producing new theory and new types of management practices. With respect to theoretical implications, the findings showed that the strategic utilization of AI advancements has not been all-around investigated by researchers yet, in spite of digital and cognitive strategies to take strategic benefits of the AI working with people. Along these lines, given the ascent of AI in the digital age, there are still gaps in order to examine the formulation and implementation of the new age of AI in various settings of assorted scales and industry possibilities.

Corresponding to managerial implications, the outcomes of this paper can be a manual for management and organizational practices, requesting new types of strategic decisionmaking and organizational culture reshaping. Besides, the exhibit of the AI and corporate strategy association can assist managers in receiving these new advancements with more noteworthy mindfulness about the opportunities, difficulties and advantages that AI may provide to their businesses.

Considering the aforementioned, difficulties and future research opportunities were set up in light of the outcomes of the literature review. In this way, knowledge gaps and exploration recommendations were discussed regarding the generation of value with the usage of AI and its association with corporate strategy. As per the findings of the literature review, the association among AI and organizational strategy to decision-making was tended to by most articles. Nevertheless, ongoing studies in deep learning [54,63,73–75] have not been all ground attended to yet. In this manner, no exact proof about the automation of the decision-making viability has been provided. This outcome might be identified with the difficulty of the association between AI and human, which likewise impacts decision-making automation [51]. Notwithstanding, in the age of digital transformation, big data and the requirement for speed-to-lead organizations, AI advances can settle on better decisions over people in certain unique situations and humans can choose better when critical thinking is needed [49,76–81]. Along these lines, it is essential to examine how leading companies implement strategies to exploit the AI potential and to change the AI–human condition for producing business value [36].

The review was conducted utilizing the terms identified with corporate strategy or IT strategy, not indicating other organizational strategy dimensions, for example, operational strategy and financial strategy. Future researchers may broaden the search string and use these viewpoints. Also, the dimensions introduced in the theoretical framework can trigger further research, paying attention in a particular way.

This article has a few limitations that are presented below. Only peer-reviewed journals have been incorporated in the dataset to date, but there are likewise related articles in conference proceedings or book chapters. Another limitation is that only English articles were looked through, an approach which may skip different publications in different languages. In this way, the utilization of various journals or articles from different sources could conceivable lead to different outcomes. This article could be considered as a beginning stage for future examination features topics among AI and corporate strategy, while giving a review of the literature from an alternative point of view, not actualized in current studies. Future researchers may extend this literature review and perform a bibliometric analysis, for example co-author or co-citation.

Author Contributions: Conceptualization, F.K.; methodology, F.K.; data collection, M.K.; writing— original draft preparation, M.K.; writing—review and editing, F.K.; M.K.; supervision, F.K. All authors have read and agreed to the published version of the manuscript.

Funding: This research received no external funding.

Institutional Review Board Statement: Not applicable.

Informed Consent Statement: Not applicable.

Data Availability Statement: This study did not report any data.

Conflicts of Interest: The authors declare no conflict of interest.

# Appendix A

Table A1. Concept matrix table.   

<html><body><table><tr><td colspan="3"></td><td colspan="4">Concepts</td></tr><tr><td>No.</td><td>Authors</td><td>Year</td><td></td><td>Alig it AI Tools and Strategy</td><td></td><td> InnovAli Servi Value</td></tr><tr><td>Balog [2]</td><td>Akhtar et al. [1]</td><td></td><td></td><td>X</td><td></td><td></td></tr><tr><td>Duan et al. [3]</td><td></td><td>2020</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Lichtenthaler [4]</td><td>2019 2020b</td><td></td><td>X</td><td></td><td></td></tr><tr><td></td><td>Bozic and Dimovski [5]</td><td>2019</td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Chen and Siau [6]</td><td>2020</td><td></td><td></td><td></td><td>X</td></tr><tr><td></td><td>Sujata et al. [7]</td><td>2019</td><td></td><td></td><td></td><td>X</td></tr><tr><td></td><td>Taylor et al. [8]</td><td>2020</td><td></td><td></td><td></td><td>X</td></tr><tr><td></td><td>Vasin et al. [9]</td><td>2018</td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Vidgen et al. [10]</td><td>2017</td><td></td><td></td><td>X</td><td></td></tr><tr><td>Wamba-Taguimdje et al. [11]</td><td></td><td>2020</td><td>X</td><td></td><td></td><td>X</td></tr><tr><td></td><td>Zaki[12]</td><td>2019</td><td>X</td><td></td><td></td><td>X</td></tr><tr><td></td><td>Yin et al. [13]</td><td>2020</td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Pappas et al. [14]</td><td>2018</td><td>X</td><td></td><td></td><td></td></tr><tr><td></td><td>Angelis and da Silva [15]</td><td>2019</td><td></td><td>X</td><td>X</td><td>X</td></tr><tr><td></td><td>Mikalef et al. [16]</td><td>2019</td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Ranjan and Foropon [17]</td><td>2021</td><td>X</td><td></td><td></td><td>X</td></tr><tr><td></td><td>Reis et al. [18]</td><td>2020</td><td>X</td><td>X</td><td></td><td></td></tr><tr><td></td><td>Liu[19]</td><td>2013</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Arnott [20]</td><td>2010</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Goralski and Tan [21]</td><td>2020</td><td>X</td><td></td><td></td><td></td></tr><tr><td></td><td>Nalchigar and Yu [22]</td><td>2017</td><td>X</td><td>X</td><td>X</td><td></td></tr><tr><td>Dabrowski [23]</td><td></td><td>2017</td><td></td><td>X</td><td></td><td></td></tr><tr><td>Ghasemaghaei [24]</td><td></td><td>2019</td><td></td><td></td><td>X</td><td></td></tr><tr><td>Lei and Wang [25]</td><td></td><td>2020</td><td></td><td></td><td>X</td><td></td></tr><tr><td>Ashrafi et al. [26]</td><td></td><td>2019</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td>Ciampi et al. [27]</td><td></td><td>2020</td><td></td><td></td><td></td><td></td></tr><tr><td>Dealbgos-Gemerod28]</td><td></td><td></td><td>X</td><td></td><td></td><td>X</td></tr><tr><td></td><td></td><td>2020</td><td></td><td></td><td></td><td></td></tr><tr><td>Yiu et al. [29]</td><td></td><td>2020</td><td>X</td><td></td><td></td><td></td></tr><tr><td>Dwivedi et al. [30]</td><td></td><td>2009</td><td></td><td>X</td><td></td><td></td></tr><tr><td>Kathuria et al. [31]</td><td></td><td>1999</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td>Pinson et al. [32]</td><td></td><td>1997</td><td></td><td></td><td>X</td><td></td></tr><tr><td>Tallon and Pinsonneault [33]</td><td></td><td>2011</td><td></td><td>X</td><td></td><td></td></tr><tr><td>Orsini [34]</td><td></td><td>1986</td><td></td><td>X</td><td></td><td></td></tr><tr><td>Orwig et al. [35]</td><td></td><td>1997</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td>Lichtenthaler [36]</td><td></td><td>2020a</td><td></td><td>X</td><td></td><td></td></tr><tr><td>Olsson and Bosch [47]</td><td></td><td>2020</td><td></td><td>X</td><td></td><td>X</td></tr><tr><td>Wang et al. [48]</td><td></td><td>2020</td><td>X</td><td></td><td></td><td></td></tr><tr><td>Xing et al.[49]</td><td></td><td>2016</td><td>X</td><td></td><td></td><td></td></tr><tr><td>Harlow [50]</td><td></td><td>2018</td><td></td><td>X</td><td>X</td><td></td></tr></table></body></html>

Table A1. Cont.   

<html><body><table><tr><td></td><td></td><td></td><td colspan="2">Concepts</td><td></td></tr><tr><td>No.</td><td>Authors</td><td>Year</td><td></td><td>Alig wigAI Tolsand Strategy</td><td></td><td> InnovALi Seri Value</td></tr><tr><td></td><td>Zimmermann et al. [51]</td><td>2020</td><td>X</td><td>X</td><td></td><td>X</td></tr><tr><td></td><td>Iyer and Schkade [52]</td><td>1987</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Coakes et al. [53]</td><td>1997</td><td></td><td>X</td><td></td><td></td></tr><tr><td></td><td>Warner and Wager [54]</td><td>2019</td><td></td><td>X</td><td></td><td></td></tr><tr><td></td><td>George et al. [55]</td><td>2020</td><td></td><td>X</td><td></td><td>X</td></tr><tr><td></td><td>Lenart-Gansiniec [56]</td><td>2019</td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Chae [57]</td><td>2014</td><td></td><td></td><td></td><td>X</td></tr><tr><td></td><td>Feldmann et al. [58]</td><td>2013</td><td>X</td><td></td><td></td><td>X</td></tr><tr><td></td><td>Holmlund et al. [59]</td><td>2020</td><td></td><td>X</td><td></td><td>X</td></tr><tr><td></td><td>Kohler et al. [60]</td><td>2014</td><td>X</td><td></td><td></td><td>X</td></tr><tr><td></td><td>Li et al. [61]</td><td>2008</td><td></td><td></td><td>X</td><td>X</td></tr><tr><td></td><td>Sabherwal and Chan [62]</td><td>2001</td><td></td><td>X</td><td></td><td></td></tr><tr><td></td><td>Aversa et al. [63]</td><td>2018</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Charoensuk et al. [64]</td><td>2014</td><td></td><td>X</td><td></td><td></td></tr><tr><td></td><td>Isal et al. [65]</td><td>2016</td><td></td><td>X</td><td></td><td></td></tr><tr><td></td><td>Liang et al. [66]</td><td>2017</td><td></td><td>X</td><td></td><td></td></tr><tr><td></td><td>Becker and Schmid [67]</td><td>2020</td><td></td><td>X</td><td></td><td></td></tr><tr><td></td><td>Hsieh [68]</td><td>2009</td><td></td><td></td><td>X</td><td>X</td></tr><tr><td></td><td>Schrettenbrunner [69]</td><td>2020</td><td>X</td><td></td><td></td><td></td></tr><tr><td></td><td>Demirkan and Delen [70]</td><td>2013</td><td></td><td></td><td>X</td><td>X</td></tr><tr><td></td><td>Huang and Rust [71]</td><td>2020</td><td></td><td>X</td><td></td><td></td></tr><tr><td></td><td>Caputo et al. [72]</td><td>2019</td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>De Carlo et al. [74]</td><td>2020</td><td>X</td><td>X</td><td></td><td></td></tr><tr><td></td><td>de Medeiros et al. [75]</td><td>2020</td><td></td><td>X</td><td></td><td>X</td></tr><tr><td></td><td>Tabesh et al. [76]</td><td>2019</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Achillas et al. [82]</td><td>2017</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Amping et al. [83]</td><td>2019</td><td></td><td>X</td><td></td><td></td></tr><tr><td></td><td>Anderson [84]</td><td>2019</td><td>X</td><td></td><td>X</td><td></td></tr><tr><td></td><td>Arbatani et al. [85]</td><td>2019</td><td></td><td>X</td><td></td><td></td></tr><tr><td></td><td>Arnott et al. [86]</td><td>2017</td><td></td><td></td><td>X</td><td></td></tr><tr><td>Bergqvist and Lounamaa [87]</td><td></td><td>1987</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td>Borch and Hartvigsen [88]</td><td></td><td>1991</td><td></td><td>X</td><td></td><td></td></tr><tr><td>Chatwin et al. [89]</td><td></td><td>1996</td><td></td><td></td><td></td><td></td></tr><tr><td>Durrani and Forbes [90]</td><td></td><td>2018</td><td></td><td>X</td><td></td><td></td></tr><tr><td>Eckert and Osterrieder [91]</td><td></td><td>2020</td><td></td><td>X</td><td></td><td>X</td></tr><tr><td>Khan et al. [92]</td><td></td><td>2020</td><td>X</td><td></td><td></td><td></td></tr><tr><td>Ryou et al. [93]</td><td></td><td>2020</td><td></td><td>X</td><td></td><td></td></tr><tr><td>Sawhney [94]</td><td></td><td>1991</td><td></td><td>X</td><td></td><td></td></tr><tr><td>Sharma et al. [95]</td><td></td><td>2014</td><td></td><td></td><td>X</td><td>X</td></tr><tr><td>Sviokla [96]</td><td>Thow-Yick and Huu-Phuong [97]</td><td>1986 1990</td><td></td><td>X</td><td>X</td><td></td></tr></table></body></html>

# References

1. Akhtar, P.; Frynas, J.G.; Mellahi, K.; Ullah, S. Big data-savvy teams’ skills, big data-driven actions and business performance. Br. J. Manag. 2019, 30, 252–271. [CrossRef]   
2. Balog, K. The concept and competitiveness of agile organization in the fourth industrial revolution’s drift. Strateg. Manag. 2020, 25, 14–27. [CrossRef]   
3. Duan, Y.; Edwards, J.S.; Dwivedi, Y.K. Artificial intelligence for decision making in the era of Big Data–evolution, challenges and research agenda. Int. J. Inf. Manag. 2019, 48, 63–71. [CrossRef]   
4. Lichtenthaler, U. Building blocks of successful digital transformation: Complementing technology and market issues. Int. J. Innov. Technol. Manag. 2020, 17. [CrossRef]   
5. Božiˇc, K.; Dimovski, V. Business intelligence and analytics use, innovation ambidexterity, and firm performance: A dynamic capabilities perspective. J. Strateg. Inf. Syst. 2019, 28. [CrossRef]   
6. Chen, X.; Siau, K. Business analytics/business intelligence and IT infrastructure: Impact on organizational agility. J. Organ. End User Comput. 2020, 32, 138–161. [CrossRef]   
7. Sujata, J.; Aniket, D.; Mahasingh, M. Artificial intelligence tools for enhancing customer experience. Int. J. Recent Technol. Eng. 2019, 2, 700–706. [CrossRef]   
8. Taylor, S.A.; Hunter, G.L.; Zadeh, A.H.; Delpechitre, D.; Lim, J.H. Value propositions in a digitally transformed world. Ind. Mark. Manag. 2020, 87, 256–263. [CrossRef]   
9. Vasin, S.; Gamidullaeva, L.; Shkarupeta, E.; Finogeev, A.; Palatkin, I. Emerging trends and opportunities for industry 4.0 development in Russia. Eur. Res. Stud. J. 2018, 21, 63–76. [CrossRef]   
10. Vidgen, R.; Shaw, S.; Grant, D.B. Management challenges in creating value from business analytics. Eur. J. Oper. Res. 2017, 261, 626–639. [CrossRef]   
11. Wamba-Taguimdje, S.L.; Wamba, S.F.; Kamdjoug, J.R.K.; Wanko, C.E.T. Influence of artificial intelligence (AI) on firm performance: The business value of AI-based transformation projects. Bus. Process. Manag. J. 2020, 26, 1893–1924. [CrossRef]   
12. Zaki, M. Digital transformation: Harnessing digital technologies for the next generation of services. J. Serv. Mark. 2019, 33, 429–435. [CrossRef]   
13. Yin, J.; Wei, S.; Chen, X.; Wei, J. Does it pay to align a firm’s competitive strategy with its industry IT strategic role. Inf. Manag. 2020, 57. [CrossRef]   
14. Pappas, I.O.; Mikalef, P.; Giannakos, M.N.; Krogstie, J.; Lekakos, G. Big data and business analytics ecosystems: Paving the way towards digital transformation and sustainable societies. Inf. Syst. e-Bus. Manag. 2018, 16, 479–491. [CrossRef]   
15. Angelis, J.; da Silva, E.R. Blockchain adoption: A value driver perspective. Bus. Horiz. 2019, 62, 307–314. [CrossRef]   
16. Mikalef, P.; Boura, M.; Lekakos, G.; Krogstie, J. Big data analytics and firm performance: Findings from a mixed-method approach. J. Bus. Res. 2019, 98, 261–276. [CrossRef]   
17. Ranjan, J.; Foropon, C. Big Data Analytics in Building the Competitive Intelligence of Organizations. Int. J. Inf. Manag. 2021, 56, 102231. [CrossRef]   
18. Reis, C.; Ruivo, P.; Oliveira, T.; Faroleiro, P. Assessing the drivers of machine learning business value. J. Bus. Res. 2020, 117, 232–243. [CrossRef]   
19. Liu, Y. Sustainable competitive advantage in turbulent business environments. Int. J. Prod. Res. 2013, 51, 2821–2841. [CrossRef]   
20. Arnott, D. Senior executive information behaviors and decision support. J. Decis. Syst. 2010, 19, 465–480. [CrossRef]   
21. Goralski, M.A.; Tan, T.K. Artificial intelligence and sustainable development. Int. J. Manag. Educ. 2020, 18. [CrossRef]   
22. Nalchigar, S.; Yu, E. Conceptual modeling for business analytics: A framework and potential benefits. In Proceedings of the 2017 IEEE 19th Conference on Business Informatics, Thessaloniki, Greece, 24–26 July 2017.   
23. D ˛abrowski, J. Towards an adaptive framework for goal-oriented strategic decision-making. In Proceedings of the 2017 IEEE 25th International Requirements Engineering Conference (RE), Lisbon, Portugal, 4–8 September 2017.   
24. Ghasemaghaei, M. Does data analytics use improve firm decision making quality? The role of knowledge sharing and data analytics competency. Decis. Support. Syst. 2019, 120, 14–24. [CrossRef]   
25. Lei, Z.; Wang, L. Construction of organisational system of enterprise knowledge management networking module based on artificial intelligence. Knowl. Manag. Res. Pract. 2020, in press. [CrossRef]   
26. Ashrafi, A.; Ravasan, A.Z.; Trkman, P.; Afshari, S. The role of business analytics capabilities in bolstering firms’ agility and performance. Int. J. Inf. Manag. 2019, 47, 1–15. [CrossRef]   
27. Ciampi, F.; Demi, S.; Magrini, A.; Marzi, G.; Papa, A. Exploring the impact of big data analytics capabilities on business model innovation: The mediating role of entrepreneurial orientation. J. Bus. Res. 2020, 123, 1–13. [CrossRef]   
28. Gallego-Gomez, C.; De-Pablos-Heredero, C. Artificial Intelligence as an Enabling Tool for the Development of Dynamic Capabilities in the Banking Industry. Int. J. Enterp. Inf. Syst. 2020, 16, 20–33. [CrossRef]   
29. Yiu, L.D.; Yeung, A.C.; Jong, A.P. Business intelligence systems and operational capability: An empirical analysis of high-tech sectors. Ind. Manag. Data Syst. 2020, 120, 1195–1215. [CrossRef]   
30. Dwivedi, Y.K.; Papazafeiropoulo, A.; Gutierrez, A.; Orozco, J.; Serrano, A. Factors affecting IT and business alignment: A comparative study in SMEs and large organisations. J. Enterp. Inf. Manag. 2009, 22, 197–211. [CrossRef]   
31. Kathuria, R.; Anandarajan, M.; Igbaria, M. Linking IT applications with manufacturing strategy: An intelligent decision support system approach. Decis. Sci. 1999, 30, 959–991. [CrossRef]   
32. Pinson, S.D.; Louçã, J.A.; Moraitis, P. A distributed decision support system for strategic planning. Decis. Support. Syst. 1997, 20, 35–51. [CrossRef]   
33. Tallon, P.P.; Pinsonneault, A. Competing perspectives on the link between strategic information technology alignment and organizational agility: Insights from a mediation model. MIS Q. 2011, 35, 463–486. [CrossRef]   
34. Orsini, J.F. Artificial intelligence: A way through the strategic planning crisis. Long Range Plan. 1986, 19, 71–77. [CrossRef]   
35. Orwig, R.; Chen, H.; Vogel, D.; Nunamaker, J.F. A multi-agent view of strategic planning using group support systems and artificial intelligence. Group Decis. Negot. 1997, 6, 37–59. [CrossRef]   
36. Lichtenthaler, U. Beyond artificial intelligence: Why companies need to go the extra step. J. Bus. Strateg. 2020, 41, 19–26. [CrossRef]   
37. Webster, J.; Watson, R.T. Analyzing the Past to Prepare for the Future: Writing a Literature Review. MIS Q. 2002, 26, 13–23. [CrossRef]   
38. Kitsios, F.; Kamariotou, M. Mapping new service development: A review and synthesis of literature. Serv. Ind. J. 2020, 40, 682–704. [CrossRef]   
39. Kitsios, F.; Kamariotou, M.; Talias, M.A. Corporate Sustainability Strategies and Decision Support Methods: A Bibliometric Analysis. Sustainability 2020, 12, 521. [CrossRef]   
40. Kitsios, F.; Kamariotou, M. Business strategy modelling based on enterprise architecture: A state of the art review. Bus. Process. Manag. J. 2019, 25, 606–624. [CrossRef]   
41. Kitsios, F.; Kamariotou, M. Service innovation process digitization: Areas for exploitation and exploration. J. Hosp. Tour. Technol. 2019, in press. [CrossRef]   
42. Kitsios, F.; Kamariotou, M. Decision Support Systems and Business Strategy: A conceptual framework for Strategic Information Systems Planning. In Proceedings of the 6th IEEE International Conference on IT Convergence and Security (ICITCS2016), Prague, Czech Republic, 23–26 September 2016.   
43. Kitsios, F. , M. The im nology and the alignm en b strategy on service innovation performance. In Proceedings of the 3rd IEEE International Conference on Industrial Engineering, Management Science and Applications (ICIMSA 2016), Jeju Island, Korea, 23–26 May 2016.   
44. Borges, A.F.; Laurindo, F.J.; Spínola, M.M.; Gonçalves, R.F.; Mattos, C.A. The strategic use of artificial intelligence in the digital era: Systematic literature review and future research directions. Int. J. Inf. Manag. 2020, in press. [CrossRef]   
45. Caner, S.; Bhatti, F. A Conceptual Framework on Defining Businesses Strategy for Artificial Intelligence. Contemp. Manag. Res. 2020, 16, 175–206. [CrossRef]   
46. Trunk, A.; Birkel, H.; Hartmann, E. On the current state of combining human and artificial intelligence for strategic organizational decision making. Bus. Res. 2020, in press. [CrossRef]   
47. Olsson, H.H.; Bosch, J. Going digital: Disruption and transformation in software-intensive embedded systems ecosystems. J. Soft. Evol. Process. 2020, 32, e2249. [CrossRef]   
48. Wang, X.; Zeng, D.; Dai, H.; Zhu, Y. Making the right business decision: Forecasting the binary NPD strategy in Chinese automotive industry with machine learning methods. Technol. Fore. Soc. Change 2020, 155. [CrossRef]   
49. Xing, E.P.; Ho, Q.; Xie, P.; Wei, D. Strategies and principles of distributed machine learning on big data. Engineering 2016, 2, 179–195. [CrossRef]   
50. Harlow, H.D. Developing a knowledge management strategy for data analytics and intellectual capital. Med. Account. Res. 2018, 26, 400–419. [CrossRef]   
51. Zimmermann, A.; Schmidt, R.; Sandkuhl, K. Strategic Challenges for Platform-based Intelligent Assistants. Proc. Comput. Sci. 2020, 176, 966–975. [CrossRef]   
52. Iyer, R.K.; Schkade, L.L. Management support systems for multinational business. Inf. Manag. 1987, 12, 59–64. [CrossRef]   
53. Coakes, E.; Merchant, K.; Lehaney, B. The use of expert systems in business transformation. Manag. Decis. 1997, 35, 53–57. [CrossRef]   
54. Warner, K.S.; Wäger, M. Building dynamic capabilities for digital transformation: An ongoing process of strategic renewal. Long Range Plan. 2019, 52, 326–349. [CrossRef]   
55. George, A.; Schmitz, K.; Storey, V.C. A Framework for Building Mature Business Intelligence and Analytics in Organizations. J. Database Manag. 2020, 31, 14–39. [CrossRef]   
56. Lenart-Gansiniec, R. Organizational Learning in Industry 4.0. Probl. Zarz. 2019, 17, 96–108. [CrossRef]   
57. Chae, B.K. A complexity theory approach to IT-enabled services (IESs) and service innovation: Business analytics as an illustration of IES. Decis. Support Syst. 2014, 57, 1–10. [CrossRef]   
58. Feldmann, N.; Kohler, M.; Kimbrough, S.O.; Fromm, H. Service innovation analytics: Towards an approach for validating frameworks for service innovation capabilities via text mining. In Exploring Services Science. IESS 2013. Lecture Notes in Business Information Processing; Falcão e Cunha, J., Snene, M., Nóvoa, H., Eds.; Springer: Berlin/Heidelberg, Germany, 2013; Volume 143, pp. 73–85.   
59. Holmlund, M.; Van Vaerenbergh, Y.; Ciuchita, R.; Ravald, A.; Sarantopoulos, P.; Ordenes, F.V.; Zaki, M. Customer experience management in the age of big data analytics: A strategic framework. J. Bus. Res. 2020, 116, 356–365. [CrossRef]   
60. Kohler, M.; Feldmann, N.; Kimbrough, S.O.; Fromm, H. Service innovation analytics: Leveraging existing unstructured data to assess service innovation capability. Int. J. Inf. Syst. Model. Des. 2014, 5, 1–21. [CrossRef]   
61. Li, S.T.; Shue, L.Y.; Lee, S.F. Business intelligence approach to supporting strategy-making of ISP service management. Exp. Syst. Appl. 2008, 35, 739–754. [CrossRef]   
62. Sabherwal, R.; Chan, Y.E. Alignment between business and IS strategies: A study of prospectors, analyzers, and defenders. Inf. Syst. Res. 2001, 12, 11–33. [CrossRef]   
63. Aversa, P.; Cabantous, L.; Haefliger, S. When decision support systems fail: Insights for strategic information systems from Formula 1. J. Strateg. Inf. Syst. 2018, 27, 221–236. [CrossRef]   
64. Charoensuk, S.; Wongsurawat, W.; Khang, D.B. Business-IT Alignment: A practical research approach. J. High. Technol. Manag. Res. 2014, 25, 132–147. [CrossRef]   
65. Isal, Y.K.; Pikarti, G.P.; Hidayanto, A.N.; Putra, E.Y. Analysis of IT infrastructure flexibility impacts on IT-Business strategic alignment. J. Ind. Eng. Manag. 2016, 9, 657–683. [CrossRef]   
66. Liang, H.; Wang, N.; Xue, Y.; Ge, S. Unraveling the alignment paradox: How does business—IT alignment shape organizational agility. Inf. Syst. Res. 2017, 28, 863–879. [CrossRef]   
67. Becker, W.; Schmid, O. The right digital strategy for your business: An empirical analysis of the design and implementation of digital strategies in SMEs and LSEs. Bus. Res. 2020, in press. [CrossRef]   
68. Hsieh, K.L. Applying an expert system into constructing customer’s value expansion and prediction model based on AI techniques in leisure industry. Exp. Syst. Appl. 2009, 36, 2864–2872. [CrossRef]   
69. Schrettenbrunner, M.B. Artificial Intelligence Driven Management. IEEE Eng. Manag. Rev. 2020, 48, 15–19. [CrossRef]   
70. Demirkan, H.; Delen, D. Leveraging the capabilities of service-oriented decision support systems: Putting analytics and big data in cloud. Decis. Support. Syst. 2013, 55, 412–421. [CrossRef]   
71. Huang, M.H.; Rust, R.T. A strategic framework for artificial intelligence in marketing. J. Acad. Mark. Sci. 2020, in press. [CrossRef]   
72. Caputo, F.; Cillo, V.; Candelo, E.; Liu, Y. Innovating through digital revolution. The role of Soft Skills and Big Data in increasing firm performance. Manag. Decis. 2019, 57, 2032–2051. [CrossRef]   
73. Chersan, I.C.; Dumitru, V.F.; Gorgan Cand Gorgan, V. Green Public Procurement in the Academic Literature. Econ. Amphitheater 2020, 22, 82–101. [CrossRef]   
74. De Carlo, M.; Ferilli, G.; d’Angella, F.; Buscema, M. Artificial intelligence to design collaborative strategy: An application to urban destinations. J. Bus. Res. 2020, in press. [CrossRef]   
75. de Medeiros, M.M.; Maçada, A.C.G.; Junior, J.C.D.S.F. The effect of data strategy on competitive advantage. Bottom Line 2020, 33, 201–216. [CrossRef]   
76. Tabesh, P.; Mousavidin, E.; Hasani, S. Implementing big data strategies: A managerial perspective. Bus. Horiz. 2019, 62, 347–358. [CrossRef]   
77. Angelopoulos, S.P.; Kitsios, F.C.; Babulak, E. From e to u: Towards an innovative digital era. In Ubiquitous and Pervasive Computing: Concepts, Methodologies, Tools, and Applications; Kotsopoulos, S., Ioannou, K., Eds.; IGI global: Hershey, PA, USA, 2008; pp. 1669–1687.   
78. Angelopoulos, S.; Kitsios, F.; Moustakis, V. Transformation of management in the Public Sector: Exploring the Strategic Frameworks of e-Government. In Public sector reform using information technologies: Transforming policy into practice; Papadopoulos, T., Kanellis, P., Eds.; IGI global: Hershey, PA, USA, 2011; pp. 44–58.   
79. Kitsios, F.; Delimpasis, T.; Kamariotou, M. Digital Business Strategy: An Empirical Analysis of Mission statement content and Financial Performance. In Proceedings of the 19th International Conference on Electronic Business, ICEB 2019, Newcastle upon Tyne, UK, 8–12 December 2019.   
80. Mitroulis, D.; Kitsios, F. Using multicriteria decision analysis to evaluate the effect of digital transformation on organizational performance: Evidence from Greek tourism SMEs. Int. J. Decis. Support. Syst. 2019, 4, 143–158. [CrossRef]   
81. Mitroulis, D.; Kitsios, F. Evaluating digital transformation strategies: A MCDA analysis of Greek tourism SMEs. In Proceedings of the 14th European Conference on Innovation and Entrepreneurship (ECIE19), Kalamata, Greece, 19–20 September 2019.   
82. Achillas, C.; Tzetzis, D.; Raimondo, M.O. Alternative production strategies based on the comparison of additive and traditional manufacturing technologies. Int. J. Prod. Res. 2017, 55, 3497–3509. [CrossRef]   
83. Amping, A.; Amirah, M.M.A.; Sholehah, D.P.T.; Handoyo, A.D.Y.; Shihab, M.R.; Ranti, B.; Hidayanto, A.N. Telecommunication Business Transformation Towards to Competitive Advantage: Case Study of PT. Telekomunikasi Indonesia. In Proceedings of the 2nd International Conference of Computer and Informatics Engineering, IC2IE 2019, Banyuwangi, Indonesia, 10–11 September 2019.   
84. Anderson, P.L. Business strategy and firm location decisions: Testing traditional and modern methods. Bus. Econ. 2019, 54, 35–60. [CrossRef]   
85. Arbatani, T.R.; Norouzi, E.; Omidi, A.; Valero-Pastor, J.M. Competitive strategies of mobile applications in online taxi services. Int. J. Emerg. Mark. 2019, in press. [CrossRef]   
86. Arnott, D.; Lizama, F.; Song, Y. Patterns of business intelligence systems use in organizations. Decis. Support. Syst. 2017, 97, 58–68. [CrossRef]   
87. Bergqvist, J.T.; Lounamaa, P.H. Knowledge-based evaluation of strategic investments. In Proceedings of the IFAC Conference on Economics and Artificial Intelligence, Aix-en-Provence, France, 2–4 September 1987.   
88. Borch, O.J.; Hartvigsen, G. Knowledge-based systems for strategic market planning in small firms. Decis. Support. Syst. 1991, 7, 145–157. [CrossRef]   
89. Chatwin, C.R.; Abdullah, H.A.; Watson, I.A. A knowledge-based system for operations management in a small to medium sized enterprise. Int. J. Adv. Manuf. Technol. 1996, 11, 381–386. [CrossRef]   
90. Durrani, T.S.; Forbes, S.M. Industrial Strategy: Myth or Reality. In Proceedings of the 2018 IEEE Technology and Engineering Management Conference (TEMSCON), Chicago, IL, USA, 28–30 June 2018.   
91. Eckert, C.; Osterrieder, K. How digitalization affects insurance companies: Overview and use cases of digital technologies. Z. Gesamte Versicher. 2020, in press. [CrossRef]   
92. Khan, S.; Farnsworth, M.; McWilliam, R.; Erkoyuncu, J. On the requirements of digital twin-driven autonomous maintenance. Ann. Rev. Control. 2020, in press. [CrossRef]   
93. Ryou, H.; Bae, H.H.; Lee, H.S.; Oh, K.J. Momentum Investment Strategy Using a Hidden Markov Model. Sustainability 2020, 12, 7031. [CrossRef]   
94. Sawhney, R.S. An activity-based approach for evaluating strategic investments in manufacturing companies. J. Manuf. Syst. 1991, 10, 353–367. [CrossRef]   
95. Sharma, R.; Mithas, S.; Kankanhalli, A. Transforming decision-making processes: A research agenda for understanding the impact of business analytics on organisations. Eur. J. Inf. Syst. 2014, 23, 433–441. [CrossRef]   
96. Sviokla, J.J. Business implications of knowledge-based systems. Database Adv. Inf. Syst. 1986, 17, 5–19. [CrossRef]   
97. Thow-Yick, L.; Huu-Phuong, T. Management expert systems for competitive advantage in business. Inf. Manag. 1990, 18, 195–201. Refl